if fixture == None:
  #Ruby style booleans
  on=true=True
  off=false=False
  nil=None
  global cmds
  global TRIANGLESTRIPS
  global _
  global lsystem
  lsystem = None
  _=None
  TRIANGLESTRIPS=on
  cmds=[]
  fixture=dir() # save defined symbols!
  #>>> clr.AddReference("Sharp3D.Math")
  #>>> from Sharp3D.Math.Core import *

def print_camera():
  """print out the orientation and position of the current camera"""
  print "cameraDistance:", renderer.camera_controller.cameraDistance
  print "yaw:", renderer.camera_controller.yaw
  print "pitch:", renderer.camera_controller.pitch
  v=renderer.camera.pos
  print "pos:", v.m_x, v.m_y, v.m_z
  v=renderer.camera.lookAt
  print "lookAt:", v.m_x, v.m_y, v.m_z
  v=renderer.camera.up
  print "up:", v.m_x, v.m_y, v.m_z

def fps( onoff):
  """toggle framerate measurement 
  (note: minimize the renderform to achive framerates higher than 60 Hz)"""
  Kernel.fps( onoff)

def trianglestrips( onoff ):
  """affects triangulation of subsequently generated terrains 
  on: generates a trianglestrip
  off: will use simple triangulation"""
  TRIANGLESTRIPS=onoff
 
def fill_solid():
  """render polys filled"""
  terrain_renderer.fillmode = FillMode.Solid
  Kernel.NeedProcessing=true

def fill_wireframe():
  """render polys wireframe"""
  terrain_renderer.fillmode = FillMode.WireFrame
  Kernel.NeedProcessing=true

def fill_point():
  """render points only"""
  terrain_renderer.fillmode = FillMode.Point
  Kernel.NeedProcessing=true

def generate_terrain( subdivisions):
  """replaces the terrain with a new one with about (2^subdivisions) triangles"""
  ft = FractalTerrain2(subdivisions)
  if not TRIANGLESTRIPS:
    ft.triangulation_strategy=ft.generate_triangles
  ft.generate_vertices()
  mesh=ft.get_mesh()
  terrain_renderer.set_geometry(mesh)

def create_lsystem(defaultdepth):
  global lsystem
  lsystem = LSystem(defaultdepth)
  register_lsystem(lsystem)
  
def register_lsystem(lsys):
  lsys.StartingPosition = V3f(0,-1,0)
  lsys.Dimension = 1
  lsys.Size = 5
  mesh = lsys.getMesh()
  if not renderer.scene.ContainsKey("lsystem"):
    node = MeshNode("Lystem.node")
  else:
    node = renderer.scene["lsystem"]
  node.set_mesh(mesh)
  renderer.scenegraph.children.Add(node)
  renderer.scene["lsystem"] = node
  Kernel.NeedProcessing=true
  
def load_lsystem(nr, iter):
  global lsystem
  lsystem = LSystem.get_system(nr)
  register_lsystem(lsystem)
  for i in range(0,iter,1):
    iterate_lsystem()
  
def iterate_lsystem():
  """iterating lsystem one level"""
  lsystem.iterate()
  renderer.scene["lsystem"].set_mesh(lsystem.getMesh())
  Kernel.NeedProcessing=true
  
def iterate_back_lsystem():
  """iterating lsystem one level backwards"""
  lsystem.iterate_back()
  renderer.scene["lsystem"].set_mesh(lsystem.getMesh())
  Kernel.NeedProcessing=true
  
def commands():
  """lists all available commands"""
  # now determine array of console commands
  for c in cmds:
    print c

cmds=[x for x in dir() if x not in fixture]

def moveLightDown():
  renderer.lights[1].position = renderer.lights[1].position + V3f(0.1,0.1,0.1)
  
def moveLightUp():
  renderer.lights[1].position = renderer.lights[1].position - V3f(0.1,0.1,0.1)